const inputItem = Item.of('lote:dull_eye');
const outputItem = Item.of('endrem:cryptic_eye');
const levelRequirement = 30;
const dummyEnchantment = 'lote:cryptic_enchant';

MoreJSEvents.enchantmentTableIsEnchantable(event => {
    // by default, an item is only enchantable if it is damagable
    // and if it has a maximum stack size of 1
    // so in order to make our item enchantable, we need to mark it here

    if (event.item == inputItem) {
        event.setIsEnchantable(true);
    }
});

MoreJSEvents.enchantmentTableChanged(event => {
    // this section modifies the enchantment list inside
    // the enchantment table when the content changes
    // e.g. when an item is placed

    // make sure this is only applicable to the defined input item
    // the slot is limited to 1 item but we add the check as a security measure
    if (event.item != inputItem || event.item.count != 1) {
        return;
    }

    // assuming there are no other enchantsments, it's enough
    // to only modify the first enchantment entry
    // if you modify an item that is enchantable already, you
    // need to yeet all enchantments from all slots first
    let enchantment = event.get(0);

    // since a single enchantment can have multiple actual
    // sub enchantments, we need to yeet all of them first
    enchantment.removeEnchantments((_enchantment, _level) => {
        return true;
    });

    // after that, we add our custom enchantment
    // as well as the level requirement
    enchantment.requiredLevel = levelRequirement;
    // we use a dummy enchantment here, doesn't matter since
    // we change the tooltip anyway and cancel the event later
    // which means the enchantment is never actually applied
    enchantment.addEnchantment(dummyEnchantment, 1);

    // to update the enchanting table info, we need to call updateClue()
    enchantment.updateClue();
});

MoreJSEvents.enchantmentTableEnchant(event => {
    // this section modifies the enchantment result and is
    // called when an enchantment is clicked

    // make sure this is only applicable to the defined input item
    if (event.item != inputItem) {
        return;
    }

    // to make sure, it's only applied to our custom logic from the
    // other event, we need to make sure this is the correct enchantment
    let enchantment = event.get(0);
    if (enchantment.hasEnchantment(dummyEnchantment)) {
        // replacing the item cancels the event automatically so no
        // enchanemnt logic is applied
        event.item = outputItem;
        event.player.xpLevel = event.player.xpLevel - 30
    }
});
